<?php

/**
 * Accounts Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Accounts extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Accounts_model');
		$this->load->model('Account_types_model');
		$this->load->model('Account_headers_model');
	}

	public function index()
	{
		$data['content_title'] = 'Akun';



		$this->twiggy_display('adm/accounts/index', $data);
	}

	public function get_data_header_child()
	{
		$id = $this->input->post('id');

		$where  = array('a.account_header_id' => $id);
		$result = $this->Account_headers_model->get_data_child($where)->result();

		echo json_encode($result);
	}

	public function get_prefix()
	{
		$id = $this->input->post('id');

		$where  = array('a.account_header_child_id' => $id);
		$get_data = $this->Account_headers_model->get_data_child($where)->row_array();

		$result = "";
		if (!empty($get_data)) {
			$result = $get_data['account_header_number'] . $get_data['account_header_child_number'];
		}
		echo json_encode($result);
	}

	public function get_data()
	{
		$data = [];
		$get_data = $this->Accounts_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'              => $no,
					'id'              => $get_row->account_id,
					'name'            => $get_row->account_name,
					'number'          => $get_row->account_header_number . $get_row->account_header_child_number . $get_row->account_number,
					'type_name'       => $get_row->account_type_name,
					'header_number'   => $get_row->account_header_number,
					'header_name'     => $get_row->account_header_name,
					'header_child_name'  => $get_row->account_header_child_name,
					'group_name'      => $get_row->account_group_name,
					'normal_balance'  => $get_row->normal_balance,
					'opening_balance' => number_format($get_row->opening_balance),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();
		$prefix = "";
		$opening_balance = 0;

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('account_id' => $id);
			$get_data = $this->Accounts_model->get_data($where)->row_array();
			$opening_balance = number_format($get_data['opening_balance']);
			$prefix = $get_data['account_header_number'] . $get_data['account_header_child_number'];
		}

		$data['account_type_data']       = $this->Account_types_model->get_data()->result();
		$data['account_header_data']     = $this->Account_headers_model->get_data()->result();
		$data['id']              = $id;
		$data['content_title']   = $title;
		$data['get_data']        = $get_data;
		$data['opening_balance'] = $opening_balance;
		$data['prefix'] = $prefix;

		$this->twiggy_display('adm/accounts/edit', $data);
	}

	public function save()
	{
		// post
		$id                   = $this->input->post('id');
		$account_type         = $this->input->post('account_type');
		$account_header       = $this->input->post('account_header');
		$account_header_child = $this->input->post('header_child');
		$account_number       = $this->input->post('account_number');
		$account_name         = $this->input->post('account_name');
		$normal_balance       = $this->input->post('normal_balance');
		$opening_balance      = $this->input->post('opening_balance');
		$action               = $this->input->post('action');

		$data_save = array(
			'account_type_id'   => $account_type,
			'account_header_id' => $account_header,
			'account_header_child_id' => $account_header_child,
			'account_number'    => $account_number,
			'account_name'      => $account_name,
			'normal_balance'    => $normal_balance,
			'opening_balance'   => trims($opening_balance),
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Accounts_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Accounts_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Accounts_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$name  = $this->input->post('id');
		$where     = array('account_number' => $name);

		$check = $this->Accounts_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
